from a5_point2d import Point2D

class Rectangle:
    def __init__(self, southwest, northeast):
        self.southwest = southwest
        self.northeast = northeast
    
    def width(self):
        return abs(self.southwest.get_x() - self.northeast.get_x())
    
    def height(self):
        return abs(self.southwest.get_y() - self.northeast.get_y())
    
    def area(self):
        return self.width() * self.height()
    
    def perimeter(self):
        return 2*self.width() + 2*self.height()
    
    def get_southwest(self):
        return self.southwest
    
    def get_northwest(self):
        return Point2D(self.southwest.get_x(), self.northeast.get_y())
    
    def get_northeast(self):
        return self.northeast
    
    def get_southeast(self):
        return Point2D(self.northeast.get_x(), self.southwest.get_y())
    
r = Rectangle(Point2D(0, 0), Point2D(10, 5))

print r.southwest

print r.area()
print r.perimeter()
print r.get_southwest()
print r.get_northwest()
print r.get_northeast()
print r.get_southeast()